<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;
    
    public function fromUser()
    {
        return $this->belongsTo(User::class,'from_user_id');
    }

    public function toUser()
    {
        return $this->belongsTo(User::class,'to_user_id');
    }

    #Scope
######################
#######################
public function scopeIsNotSeen($query)
{
    return $query->where('is_seen', -1);
}
public function scopeSeen($query)
{
    return $query->where('is_seen', 1);
}
}
